// Generated by Apple Swift version 6.0.3 effective-5.10 (swiftlang-6.0.3.1.10 clang-1600.0.30.1)
#ifndef CAPTURE_SWIFT_H
#define CAPTURE_SWIFT_H
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wgcc-compat"

#if !defined(__has_include)
# define __has_include(x) 0
#endif
#if !defined(__has_attribute)
# define __has_attribute(x) 0
#endif
#if !defined(__has_feature)
# define __has_feature(x) 0
#endif
#if !defined(__has_warning)
# define __has_warning(x) 0
#endif

#if __has_include(<swift/objc-prologue.h>)
# include <swift/objc-prologue.h>
#endif

#pragma clang diagnostic ignored "-Wauto-import"
#if defined(__OBJC__)
#include <Foundation/Foundation.h>
#endif
#if defined(__cplusplus)
#include <cstdint>
#include <cstddef>
#include <cstdbool>
#include <cstring>
#include <stdlib.h>
#include <new>
#include <type_traits>
#else
#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>
#include <string.h>
#endif
#if defined(__cplusplus)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wnon-modular-include-in-framework-module"
#if defined(__arm64e__) && __has_include(<ptrauth.h>)
# include <ptrauth.h>
#else
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wreserved-macro-identifier"
# ifndef __ptrauth_swift_value_witness_function_pointer
#  define __ptrauth_swift_value_witness_function_pointer(x)
# endif
# ifndef __ptrauth_swift_class_method_pointer
#  define __ptrauth_swift_class_method_pointer(x)
# endif
#pragma clang diagnostic pop
#endif
#pragma clang diagnostic pop
#endif

#if !defined(SWIFT_TYPEDEFS)
# define SWIFT_TYPEDEFS 1
# if __has_include(<uchar.h>)
#  include <uchar.h>
# elif !defined(__cplusplus)
typedef uint_least16_t char16_t;
typedef uint_least32_t char32_t;
# endif
typedef float swift_float2  __attribute__((__ext_vector_type__(2)));
typedef float swift_float3  __attribute__((__ext_vector_type__(3)));
typedef float swift_float4  __attribute__((__ext_vector_type__(4)));
typedef double swift_double2  __attribute__((__ext_vector_type__(2)));
typedef double swift_double3  __attribute__((__ext_vector_type__(3)));
typedef double swift_double4  __attribute__((__ext_vector_type__(4)));
typedef int swift_int2  __attribute__((__ext_vector_type__(2)));
typedef int swift_int3  __attribute__((__ext_vector_type__(3)));
typedef int swift_int4  __attribute__((__ext_vector_type__(4)));
typedef unsigned int swift_uint2  __attribute__((__ext_vector_type__(2)));
typedef unsigned int swift_uint3  __attribute__((__ext_vector_type__(3)));
typedef unsigned int swift_uint4  __attribute__((__ext_vector_type__(4)));
#endif

#if !defined(SWIFT_PASTE)
# define SWIFT_PASTE_HELPER(x, y) x##y
# define SWIFT_PASTE(x, y) SWIFT_PASTE_HELPER(x, y)
#endif
#if !defined(SWIFT_METATYPE)
# define SWIFT_METATYPE(X) Class
#endif
#if !defined(SWIFT_CLASS_PROPERTY)
# if __has_feature(objc_class_property)
#  define SWIFT_CLASS_PROPERTY(...) __VA_ARGS__
# else
#  define SWIFT_CLASS_PROPERTY(...) 
# endif
#endif
#if !defined(SWIFT_RUNTIME_NAME)
# if __has_attribute(objc_runtime_name)
#  define SWIFT_RUNTIME_NAME(X) __attribute__((objc_runtime_name(X)))
# else
#  define SWIFT_RUNTIME_NAME(X) 
# endif
#endif
#if !defined(SWIFT_COMPILE_NAME)
# if __has_attribute(swift_name)
#  define SWIFT_COMPILE_NAME(X) __attribute__((swift_name(X)))
# else
#  define SWIFT_COMPILE_NAME(X) 
# endif
#endif
#if !defined(SWIFT_METHOD_FAMILY)
# if __has_attribute(objc_method_family)
#  define SWIFT_METHOD_FAMILY(X) __attribute__((objc_method_family(X)))
# else
#  define SWIFT_METHOD_FAMILY(X) 
# endif
#endif
#if !defined(SWIFT_NOESCAPE)
# if __has_attribute(noescape)
#  define SWIFT_NOESCAPE __attribute__((noescape))
# else
#  define SWIFT_NOESCAPE 
# endif
#endif
#if !defined(SWIFT_RELEASES_ARGUMENT)
# if __has_attribute(ns_consumed)
#  define SWIFT_RELEASES_ARGUMENT __attribute__((ns_consumed))
# else
#  define SWIFT_RELEASES_ARGUMENT 
# endif
#endif
#if !defined(SWIFT_WARN_UNUSED_RESULT)
# if __has_attribute(warn_unused_result)
#  define SWIFT_WARN_UNUSED_RESULT __attribute__((warn_unused_result))
# else
#  define SWIFT_WARN_UNUSED_RESULT 
# endif
#endif
#if !defined(SWIFT_NORETURN)
# if __has_attribute(noreturn)
#  define SWIFT_NORETURN __attribute__((noreturn))
# else
#  define SWIFT_NORETURN 
# endif
#endif
#if !defined(SWIFT_CLASS_EXTRA)
# define SWIFT_CLASS_EXTRA 
#endif
#if !defined(SWIFT_PROTOCOL_EXTRA)
# define SWIFT_PROTOCOL_EXTRA 
#endif
#if !defined(SWIFT_ENUM_EXTRA)
# define SWIFT_ENUM_EXTRA 
#endif
#if !defined(SWIFT_CLASS)
# if __has_attribute(objc_subclassing_restricted)
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# else
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# endif
#endif
#if !defined(SWIFT_RESILIENT_CLASS)
# if __has_attribute(objc_class_stub)
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME) __attribute__((objc_class_stub))
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_class_stub)) SWIFT_CLASS_NAMED(SWIFT_NAME)
# else
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME)
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) SWIFT_CLASS_NAMED(SWIFT_NAME)
# endif
#endif
#if !defined(SWIFT_PROTOCOL)
# define SWIFT_PROTOCOL(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
# define SWIFT_PROTOCOL_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
#endif
#if !defined(SWIFT_EXTENSION)
# define SWIFT_EXTENSION(M) SWIFT_PASTE(M##_Swift_, __LINE__)
#endif
#if !defined(OBJC_DESIGNATED_INITIALIZER)
# if __has_attribute(objc_designated_initializer)
#  define OBJC_DESIGNATED_INITIALIZER __attribute__((objc_designated_initializer))
# else
#  define OBJC_DESIGNATED_INITIALIZER 
# endif
#endif
#if !defined(SWIFT_ENUM_ATTR)
# if __has_attribute(enum_extensibility)
#  define SWIFT_ENUM_ATTR(_extensibility) __attribute__((enum_extensibility(_extensibility)))
# else
#  define SWIFT_ENUM_ATTR(_extensibility) 
# endif
#endif
#if !defined(SWIFT_ENUM)
# define SWIFT_ENUM(_type, _name, _extensibility) enum _name : _type _name; enum SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# if __has_feature(generalized_swift_name)
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) enum _name : _type _name SWIFT_COMPILE_NAME(SWIFT_NAME); enum SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# else
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) SWIFT_ENUM(_type, _name, _extensibility)
# endif
#endif
#if !defined(SWIFT_UNAVAILABLE)
# define SWIFT_UNAVAILABLE __attribute__((unavailable))
#endif
#if !defined(SWIFT_UNAVAILABLE_MSG)
# define SWIFT_UNAVAILABLE_MSG(msg) __attribute__((unavailable(msg)))
#endif
#if !defined(SWIFT_AVAILABILITY)
# define SWIFT_AVAILABILITY(plat, ...) __attribute__((availability(plat, __VA_ARGS__)))
#endif
#if !defined(SWIFT_WEAK_IMPORT)
# define SWIFT_WEAK_IMPORT __attribute__((weak_import))
#endif
#if !defined(SWIFT_DEPRECATED)
# define SWIFT_DEPRECATED __attribute__((deprecated))
#endif
#if !defined(SWIFT_DEPRECATED_MSG)
# define SWIFT_DEPRECATED_MSG(...) __attribute__((deprecated(__VA_ARGS__)))
#endif
#if !defined(SWIFT_DEPRECATED_OBJC)
# if __has_feature(attribute_diagnose_if_objc)
#  define SWIFT_DEPRECATED_OBJC(Msg) __attribute__((diagnose_if(1, Msg, "warning")))
# else
#  define SWIFT_DEPRECATED_OBJC(Msg) SWIFT_DEPRECATED_MSG(Msg)
# endif
#endif
#if defined(__OBJC__)
#if !defined(IBSegueAction)
# define IBSegueAction 
#endif
#endif
#if !defined(SWIFT_EXTERN)
# if defined(__cplusplus)
#  define SWIFT_EXTERN extern "C"
# else
#  define SWIFT_EXTERN extern
# endif
#endif
#if !defined(SWIFT_CALL)
# define SWIFT_CALL __attribute__((swiftcall))
#endif
#if !defined(SWIFT_INDIRECT_RESULT)
# define SWIFT_INDIRECT_RESULT __attribute__((swift_indirect_result))
#endif
#if !defined(SWIFT_CONTEXT)
# define SWIFT_CONTEXT __attribute__((swift_context))
#endif
#if !defined(SWIFT_ERROR_RESULT)
# define SWIFT_ERROR_RESULT __attribute__((swift_error_result))
#endif
#if defined(__cplusplus)
# define SWIFT_NOEXCEPT noexcept
#else
# define SWIFT_NOEXCEPT 
#endif
#if !defined(SWIFT_C_INLINE_THUNK)
# if __has_attribute(always_inline)
# if __has_attribute(nodebug)
#  define SWIFT_C_INLINE_THUNK inline __attribute__((always_inline)) __attribute__((nodebug))
# else
#  define SWIFT_C_INLINE_THUNK inline __attribute__((always_inline))
# endif
# else
#  define SWIFT_C_INLINE_THUNK inline
# endif
#endif
#if defined(_WIN32)
#if !defined(SWIFT_IMPORT_STDLIB_SYMBOL)
# define SWIFT_IMPORT_STDLIB_SYMBOL __declspec(dllimport)
#endif
#else
#if !defined(SWIFT_IMPORT_STDLIB_SYMBOL)
# define SWIFT_IMPORT_STDLIB_SYMBOL 
#endif
#endif
#if defined(__OBJC__)
#if __has_feature(objc_modules)
#if __has_warning("-Watimport-in-framework-header")
#pragma clang diagnostic ignored "-Watimport-in-framework-header"
#endif
@import Foundation;
@import ObjectiveC;
#endif

#endif
#pragma clang diagnostic ignored "-Wproperty-attribute-mismatch"
#pragma clang diagnostic ignored "-Wduplicate-method-arg"
#if __has_warning("-Wpragma-clang-attribute")
# pragma clang diagnostic ignored "-Wpragma-clang-attribute"
#endif
#pragma clang diagnostic ignored "-Wunknown-pragmas"
#pragma clang diagnostic ignored "-Wnullability"
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"
#pragma clang diagnostic ignored "-Wunsafe-buffer-usage"

#if __has_attribute(external_source_symbol)
# pragma push_macro("any")
# undef any
# pragma clang attribute push(__attribute__((external_source_symbol(language="Swift", defined_in="Capture",generated_declaration))), apply_to=any(function,enum,objc_interface,objc_category,objc_protocol))
# pragma pop_macro("any")
#endif

#if defined(__OBJC__)
enum CAPSleepMode : int8_t;

/// A configuration representing the feature set enabled for Capture via Objective-C.
SWIFT_CLASS("_TtC7Capture16CAPConfiguration")
@interface CAPConfiguration : NSObject
/// Initializes a new instance of the Capture configuration.
/// \param enableFatalIssueReporting true if Capture should enable Fatal Issue Reporting
///
/// \param enableURLSessionIntegration true if Capture should enable Fatal Issue Reporting
///
- (nonnull instancetype)initWithEnableFatalIssueReporting:(BOOL)enableFatalIssueReporting enableURLSessionIntegration:(BOOL)enableURLSessionIntegration OBJC_DESIGNATED_INITIALIZER;
/// Initializes a new instance of the Capture configuration.
/// \param enableFatalIssueReporting true if Capture should enable Fatal Issue Reporting
///
/// \param enableURLSessionIntegration true if Capture should enable Fatal Issue Reporting
///
/// \param sleepMode CAPSleepModeActive if Capture should initialize in minimal activity mode
///
- (nonnull instancetype)initWithEnableFatalIssueReporting:(BOOL)enableFatalIssueReporting enableURLSessionIntegration:(BOOL)enableURLSessionIntegration sleepMode:(enum CAPSleepMode)sleepMode OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end



@class NSString;

SWIFT_CLASS("_TtC7Capture11FeatureFlag")
@interface FeatureFlag : NSObject
- (nonnull instancetype)initWithName:(NSString * _Nonnull)name variant:(NSString * _Nullable)variant OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end





/// The result of performing an HTTP Request.
SWIFT_CLASS("_TtC7Capture12HTTPResponse")
@interface HTTPResponse : NSObject
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end



/// Levels associated with a log message.
typedef SWIFT_ENUM(int32_t, LogLevel, open) {
/// ERROR mode is for when the app is in distress, and needs to be fixed as soon as possible,
  LogLevelError = 4,
/// WARNING mode is for when an unexpected technical or business event happened, but probably no immediate
/// human intervention is required. This is not necessarily an error but developers will want to review
/// these issues as soon as possible to understand the impact.
  LogLevelWarning = 3,
/// INFO mode is for things we want to see at high volume in case we need to trace back an issue.
/// “Session” lifecycle events (login, logout, etc.) go here. Typical business exceptions can go here
/// (e.g. login failed due to bad credentials).
  LogLevelInfo = 2,
/// DEBUG mode is for any message that is helpful in tracking the flow through the system and isolating
/// issues.
  LogLevelDebug = 1,
/// TRACE mode is for extremely detailed and potentially high volume logs that you don’t typically want
/// enabled even during normal development. Examples include network requests and responses.
  LogLevelTrace = 0,
};

@class CAPSessionStrategy;
@class NSURL;

SWIFT_CLASS_NAMED("LoggerObjc")
@interface CAPLogger : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER SWIFT_UNAVAILABLE;
/// Initializes the Capture SDK with the specified API key and session strategy.
/// Calling other SDK methods has no effect unless the logger has been initialized.
/// Subsequent calls to this function will have no effect.
/// \param apiKey The API key provided by bitdrift.
///
/// \param sessionStrategy A session strategy for the management of session IDs.
///
+ (void)startWithAPIKey:(NSString * _Nonnull)apiKey sessionStrategy:(CAPSessionStrategy * _Nonnull)sessionStrategy;
/// Initializes the Capture SDK with the specified API key and session strategy.
/// Calling other SDK methods has no effect unless the logger has been initialized.
/// Subsequent calls to this function will have no effect.
/// \param apiKey The API key provided by bitdrift.
///
/// \param sessionStrategy A session strategy for the management of session IDs.
///
/// \param configuration Additional options for the Capture Logger
///
+ (void)startWithAPIKey:(NSString * _Nonnull)apiKey sessionStrategy:(CAPSessionStrategy * _Nonnull)sessionStrategy configuration:(CAPConfiguration * _Nonnull)configuration;
/// Initializes the Capture SDK with the specified API key and session strategy.
/// Calling other SDK methods has no effect unless the logger has been initialized.
/// Subsequent calls to this function will have no effect.
/// \param apiKey The API key provided by bitdrift.
///
/// \param sessionStrategy A session strategy for the management of session IDs.
///
/// \param configuration Additional options for the Capture Logger
///
/// \param apiURL The base URL of Capture API.
///
+ (void)startWithAPIKey:(NSString * _Nonnull)apiKey sessionStrategy:(CAPSessionStrategy * _Nonnull)sessionStrategy configuration:(CAPConfiguration * _Nonnull)configuration apiURL:(NSURL * _Nonnull)apiURL;
/// Initializes the Capture SDK with the specified API key and session strategy.
/// Calling other SDK methods has no effect unless the logger has been initialized.
/// Subsequent calls to this function will have no effect.
/// \param apiKey The API key provided by bitdrift.
///
/// \param sessionStrategy A session strategy for the management of session IDs.
///
/// \param apiURL The base URL of the Capture API. Rely on its default value
/// unless
/// specifically instructed otherwise during discussions with
/// Bitdrift.
/// Defaults to Bitdrift’s hosted Compose API base URL.
///
/// \param enableURLSessionIntegration A flag indicating if automatic URLSession capture is enabled.
///
+ (void)startWithAPIKey:(NSString * _Nonnull)apiKey sessionStrategy:(CAPSessionStrategy * _Nonnull)sessionStrategy apiURL:(NSURL * _Nonnull)apiURL enableURLSessionIntegration:(BOOL)enableURLSessionIntegration;
/// Initializes the Capture SDK with the specified API key and session strategy.
/// Calling other SDK methods has no effect unless the logger has been initialized.
/// Subsequent calls to this function will have no effect.
/// \param apiKey The API key provided by bitdrift.
///
/// \param sessionStrategy A session strategy for the management of session IDs.
///
/// \param apiURL The base URL of the Capture API. Rely on its default value
/// unless
/// specifically instructed otherwise during discussions with
/// Bitdrift.
/// Defaults to Bitdrift’s hosted Compose API base URL.
///
/// \param enableURLSessionIntegration A flag indicating if automatic URLSession capture is enabled.
///
/// \param sleepMode .active if Capture should be initialized in minimal activity mode.
///
/// \param enableFatalIssueReporting true if Capture should enable Fatal Issue Reporting.
///
+ (void)startWithAPIKey:(NSString * _Nonnull)apiKey sessionStrategy:(CAPSessionStrategy * _Nonnull)sessionStrategy apiURL:(NSURL * _Nonnull)apiURL enableURLSessionIntegration:(BOOL)enableURLSessionIntegration sleepMode:(enum CAPSleepMode)sleepMode enableFatalIssueReporting:(BOOL)enableFatalIssueReporting;
/// Sets the operation mode of the logger, where activating sleep mode
/// reduces activity to a minimal level
/// \param mode the mode to use
///
+ (void)setSleepMode:(enum CAPSleepMode)mode;
/// Get the current version of the Capture library
///
/// returns:
/// the version as a String
+ (NSString * _Nonnull)sdkVersion SWIFT_WARN_UNUSED_RESULT;
/// Defines the initialization of a new session within the current configured logger.
/// If no logger is configured, this is a no-op.
+ (void)startNewSession;
/// Logs a trace level message to the default logger instance.
/// \param message The message to log.
///
/// \param fields The extra fields to send as part of the log.
///
+ (void)logTrace:(NSString * _Nonnull)message fields:(NSDictionary<NSString *, NSString *> * _Nullable)fields;
/// Logs a debug level message to the default logger instance.
/// \param message The message to log.
///
/// \param fields The extra fields to send as part of the log.
///
+ (void)logDebug:(NSString * _Nonnull)message fields:(NSDictionary<NSString *, NSString *> * _Nullable)fields;
/// Logs an info level message to the default logger instance.
/// \param message The message to log.
///
/// \param fields The extra fields to send as part of the log.
///
+ (void)logInfo:(NSString * _Nonnull)message fields:(NSDictionary<NSString *, NSString *> * _Nullable)fields;
/// Logs a warning level message to the default logger instance.
/// \param message The message to log.
///
/// \param fields The extra fields to send as part of the log.
///
+ (void)logWarning:(NSString * _Nonnull)message fields:(NSDictionary<NSString *, NSString *> * _Nullable)fields;
/// Logs an error level message to the default logger instance.
/// \param message The message to log.
///
/// \param fields The extra fields to send as part of the log.
///
+ (void)logError:(NSString * _Nonnull)message fields:(NSDictionary<NSString *, NSString *> * _Nullable)fields;
/// Logs a message at a specified level to the default logger instance.
/// \param level The severity of the log.
///
/// \param message The message to log.
///
/// \param fields The extra fields to send as part of the log.
///
+ (void)logWithLevel:(enum LogLevel)level message:(NSString * _Nonnull)message fields:(NSDictionary<NSString *, NSString *> * _Nullable)fields;
/// Writes an app launch TTI log event. This event should be logged only once per Logger start.
/// Consecutive calls have no effect.
/// \param duration The time between a user’s intent to launch the app and when the app becomes
/// interactive. Calls with a negative duration are ignored.
///
+ (void)logAppLaunchTTI:(NSTimeInterval)duration;
/// Writes a log that indicates that a “screen” has been presented. This is useful for snakeys and other
/// journeys visualization.
/// \param screenName The human readable unique identifier of the screen being presented.
///
+ (void)logScreenViewWithScreenName:(NSString * _Nonnull)screenName;
/// Retrieves the session ID. It’s equal to <code>nil</code> prior to the configuration of Capture SDK.
///
/// returns:
/// The ID for the current ongoing session.
+ (NSString * _Nullable)sessionID SWIFT_WARN_UNUSED_RESULT;
/// Retrieves the session URL. It is <code>nil</code> before the Capture SDK is started.
///
/// returns:
/// The Session URL represented as a string.
+ (NSString * _Nullable)sessionURL SWIFT_WARN_UNUSED_RESULT;
/// A canonical identifier for a device that remains consistent as long as an application
/// is not reinstalled.
/// The value of this property is different for apps from the same vendor running on
/// the same device. It is equal to <code>nil</code> prior to the configuration of bitdrift Capture SDK.
///
/// returns:
/// The device ID.
+ (NSString * _Nullable)deviceID SWIFT_WARN_UNUSED_RESULT;
/// Adds a field to all logs emitted by the logger from this point forward.
/// If a field with a given key has already been registered with the logger, its value is
/// replaced with the new one.
/// Fields added with this method take precedence over fields provided by registered <code>FieldProvider</code>s
/// and are overwritten by fields provided with custom logs.
/// \param key The name of the field to add.
///
/// \param value The value of the field to add.
///
+ (void)addFieldWithKey:(NSString * _Nonnull)key value:(NSString * _Nonnull)value;
/// Removes a field with a given key. This operation has no effect if a field with the given key
/// is not registered with the logger.
/// \param key The name of the field to remove.
///
+ (void)removeFieldWithKey:(NSString * _Nonnull)key;
/// Sets a feature flag with an optional variant.
/// \param name The name of the flag to set
///
/// \param variant An optional variant to set the flag to
///
+ (void)setFeatureFlagWithName:(NSString * _Nonnull)name variant:(NSString * _Nullable)variant;
/// Sets multiple feature flags.
/// \param flags The flags to set
///
+ (void)setFeatureFlags:(NSArray<FeatureFlag *> * _Nonnull)flags;
/// Removes a feature flag.
/// \param name The name of the flag to remove
///
+ (void)removeFeatureFlagWithName:(NSString * _Nonnull)name;
/// Creates a temporary device code that can be fed into other bitdrift tools to stream logs from a
/// given device in real-time fashion. The creation of the device code requires communication with
/// the bitdrift remote service.
/// \param completion The closure that is called when the operation is complete. Called on the
/// main queue.
///
+ (void)createTemporaryDeviceCodeWithCompletion:(void (^ _Nonnull)(NSString * _Nullable, NSError * _Nullable))completion;
@end













/// Describes the strategy to use for session management.
SWIFT_CLASS_NAMED("SessionStrategyObjc")
@interface CAPSessionStrategy : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER SWIFT_UNAVAILABLE;
/// A session strategy that never expires the session ID but does not survive process restart.
/// Whenever a new session is manually started via <code>startNewSession</code> method call, a new random session ID
/// is generated.
///
/// returns:
/// The fixed session strategy.
+ (CAPSessionStrategy * _Nonnull)fixed SWIFT_WARN_UNUSED_RESULT;
/// A session strategy that never expires the session ID but does not survive process restart.
/// The initial session ID is retrieved by calling the passed closure.
/// Whenever a new session is manually started via <code>startNewSession</code> method call, the closure is
/// invoked to generate a new session ID.
/// \param sessionIDGenerator The closure that returns the session ID to use. Upon the
/// initialization of the logger the closure is called on the thread
/// that’s used to configure the logger. Subsequent closure calls are
/// performed every time logger’s <code>startNewSession</code> method is called
/// using the thread on which the method is called.
///
///
/// returns:
/// The fixed session strategy.
+ (CAPSessionStrategy * _Nonnull)fixedWithSessionIDGenerator:(NSString * _Nonnull (^ _Nonnull)(void))sessionIDGenerator SWIFT_WARN_UNUSED_RESULT;
/// A session strategy that generates a new session ID after 30 minutes of app inactivity.
/// The inactivity duration is measured by the minutes elapsed since the last log. The session ID is
/// persisted to disk and survives app restarts.
/// For this session strategy, each log emitted by the SDK — including those from session replay and
/// resource monitoring feature — is considered an app activity.
///
/// returns:
/// The activity based session strategy that expires session after 30 minutes of app
/// inactivity.
+ (CAPSessionStrategy * _Nonnull)activityBased SWIFT_WARN_UNUSED_RESULT;
/// A session strategy that generates a new session ID after a certain period of app inactivity.
/// The inactivity duration is measured by the minutes elapsed since the last log. The session ID is
/// persisted to disk and survives app restarts.
/// For this session strategy, each log emitted by the SDK — including those from session replay and
/// resource monitoring feature — is considered an app activity.
/// \param inactivityThresholdMins The amount of minutes of inactivity after which a session ID
/// changes.
///
///
/// returns:
/// The activity based session strategy that expires session after a specified duration of time
/// without any app activity.
+ (CAPSessionStrategy * _Nonnull)activityBasedWithInactivityThresholdMins:(NSInteger)inactivityThresholdMins SWIFT_WARN_UNUSED_RESULT;
/// A session strategy that generates a new session ID after a certain period of app inactivity.
/// The inactivity duration is measured by the minutes elapsed since the last log. The session ID is
/// persisted to disk and survives app restarts.
/// For this session strategy, each log emitted by the SDK — including those from session replay and
/// resource monitoring feature — is considered an app activity.
/// \param inactivityThresholdMins The amount of minutes of inactivity after which a session ID
/// changes.
///
/// \param onSessionIDChange Closure that is invoked with the new value every time the session
/// ID changes. This callback is dispatched asynchronously to the
/// main queue.
///
///
/// returns:
/// The activity based session strategy that expires session after a specified duration of time
/// without any app activity.
+ (CAPSessionStrategy * _Nonnull)activityBasedWithInactivityThresholdMins:(NSInteger)inactivityThresholdMins onSessionIDChange:(void (^ _Nonnull)(NSString * _Nonnull))onSessionIDChange SWIFT_WARN_UNUSED_RESULT;
@end

typedef SWIFT_ENUM_NAMED(int8_t, CAPSleepMode, "SleepMode", open) {
  CAPSleepModeActive = 0,
  CAPSleepModeInactive = 1,
};














#endif
#if __has_attribute(external_source_symbol)
# pragma clang attribute pop
#endif
#if defined(__cplusplus)
#endif
#pragma clang diagnostic pop
#endif
